/*
 * Decompiled with CFR 0.152.
 */
package jclass.field;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import jclass.base.Border;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCArrowButton;
import jclass.bwt.JCContainer;
import jclass.bwt.JCTextCursorListener;
import jclass.bwt.JCTextField;
import jclass.bwt.JCTextInterface;
import jclass.bwt.JCTextListener;
import jclass.field.JCSpinEvent;
import jclass.field.JCSpinListener;
import jclass.field.SpinArrowButton;
import jclass.field.SpinField;
import jclass.util.JCListenerList;

public abstract class JCSpin
extends JCContainer
implements JCActionListener,
JCTextInterface {
    protected JCTextField text;
    protected SpinArrowButton decr_arrow;
    protected SpinArrowButton incr_arrow;
    protected Object value;
    protected boolean auto_arrow_disable = true;
    protected boolean arrow_key_spinning_allowed = true;
    private static boolean TRACE;
    protected int border = 2;
    protected static final int NONE = 0;
    protected static final int INCREMENT = 1;
    protected static final int DECREMENT = -1;
    static final int BEGIN = 0;
    static final int END = 1;
    protected JCListenerList listener_list;

    public JCSpin(int n) {
        this();
        this.text.setColumns(n);
    }

    public JCSpin() {
        super.setLayout(null);
        this.text = this.createTextField();
        this.add(this.text);
        this.incr_arrow = new SpinArrowButton(10, this);
        this.add(this.incr_arrow);
        this.decr_arrow = new SpinArrowButton(9, this);
        this.add(this.decr_arrow);
        this.text.addKeyListener(new textKeyListener());
        this.incr_arrow.setInitialRepeatDelay(250);
        this.decr_arrow.setInitialRepeatDelay(250);
        this.incr_arrow.setTraversable(false);
        this.decr_arrow.setTraversable(false);
        this.text.setShadowThickness(0);
        this.incr_arrow.addActionListener(this);
        this.decr_arrow.addActionListener(this);
    }

    public void requestFocus() {
        if (this.text != null) {
            this.text.requestFocus();
        }
    }

    protected JCTextField createTextField() {
        return new SpinField();
    }

    public JCTextField getTextField() {
        return this.text;
    }

    public JCArrowButton getDecrementArrow() {
        return this.decr_arrow;
    }

    public JCArrowButton getIncrementArrow() {
        return this.incr_arrow;
    }

    public boolean getAutoArrowDisable() {
        return this.auto_arrow_disable;
    }

    public void setAutoArrowDisable(boolean bl) {
        this.auto_arrow_disable = bl;
        this.checkArrowButtons();
    }

    public boolean isArrowKeySpinningAllowed() {
        return this.arrow_key_spinning_allowed;
    }

    public void setArrowKeySpinningAllowed(boolean bl) {
        this.arrow_key_spinning_allowed = bl;
    }

    public void addSpinListener(JCSpinListener jCSpinListener) {
        this.listener_list = JCListenerList.add(this.listener_list, jCSpinListener);
    }

    public void removeSpinListener(JCSpinListener jCSpinListener) {
        this.listener_list = JCListenerList.remove(this.listener_list, jCSpinListener);
    }

    protected int preferredWidth() {
        return this.text.getPreferredSize().width + this.incr_arrow.getPreferredSize().width + 2 * this.border;
    }

    protected int preferredHeight() {
        return 2 * this.border + this.text.getPreferredSize().height;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.decr_arrow.setBackground(color);
        this.incr_arrow.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.decr_arrow.setForeground(color);
        this.incr_arrow.setForeground(color);
    }

    public synchronized void doLayout() {
        int n = this.text.getPreferredSize().height;
        int n2 = n / 2;
        int n3 = this.incr_arrow.getPreferredSize().width;
        int n4 = this.getSize().width - n3 - this.border;
        int n5 = n % 2;
        this.text.setBounds(this.border, this.border, this.getSize().width - n3 - 2 * this.border, n2 * 2);
        this.incr_arrow.setBounds(n4, this.border, n3, n2);
        this.decr_arrow.setBounds(n4, n2 + this.border, n3, n2 + n5);
        this.checkArrowButtons();
    }

    public void paintInterior(Graphics graphics) {
        graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
        Border.draw(graphics, 8, this.border, 0, 0, this.getSize().width, this.getSize().height, this.getBackground(), this.getForeground());
    }

    public abstract void checkArrowButtons();

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (TRACE) {
            System.out.println("JCSpin.actionPerformed()");
        }
        int n = JCSpinEvent.NO_SPIN;
        if (jCActionEvent.getSource() == this.incr_arrow) {
            n = JCSpinEvent.SPIN_UP;
        } else if (jCActionEvent.getSource() == this.decr_arrow) {
            n = JCSpinEvent.SPIN_DOWN;
        }
        if (TRACE) {
            System.out.println("\tposting spin event");
        }
        JCSpinEvent jCSpinEvent = new JCSpinEvent(this, n, this.text.getText());
        Enumeration enumeration = JCListenerList.elements(this.listener_list);
        while (enumeration.hasMoreElements()) {
            JCSpinListener jCSpinListener = (JCSpinListener)enumeration.nextElement();
            if (TRACE) {
                System.out.println("\t\tcalling l.spin()");
            }
            jCSpinListener.spin(jCSpinEvent);
        }
        if (TRACE) {
            System.out.println("\tabout to check arrow buttons");
        }
        this.checkArrowButtons();
        if (TRACE) {
            System.out.println("\tarrow buttons checked");
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public String getSelectedText() {
        return this.text.getSelectedText();
    }

    public boolean isEditable() {
        return this.text.isEditable();
    }

    public boolean getEditable() {
        return this.text.getEditable();
    }

    public void setEditable(boolean bl) {
        this.text.setEditable(bl);
    }

    public int getSelectionStart() {
        return this.text.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.text.getSelectionEnd();
    }

    public void setSelectionStart(int n) {
        this.text.setSelectionStart(n);
    }

    public void setSelectionEnd(int n) {
        this.text.setSelectionEnd(n);
    }

    public void select(int n, int n2) {
        this.text.select(n, n2);
    }

    public void selectAll() {
        this.text.selectAll();
    }

    public void insert(String string, int n) {
        this.text.insert(string, n);
    }

    public void append(String string) {
        this.text.append(string);
    }

    public void replaceRange(String string, int n, int n2) {
        this.text.replaceRange(string, n, n2);
    }

    public int getColumns() {
        return this.text.getColumns();
    }

    public void setColumns(int n) {
        this.text.setColumns(n);
    }

    public int getAlignment() {
        return this.text.getAlignment();
    }

    public void setAlignment(int n) {
        this.text.setAlignment(n);
    }

    public int getMaximumLength() {
        return this.text.getMaximumLength();
    }

    public void setMaximumLength(int n) {
        this.text.setMaximumLength(n);
    }

    public int getStringCase() {
        return this.text.getStringCase();
    }

    public void setStringCase(int n) {
        this.text.setStringCase(n);
    }

    public void beep() {
        this.text.beep();
    }

    public boolean getChanged() {
        return this.text.getChanged();
    }

    public Dimension getMinimumSize(int n) {
        return this.text.getMinimumSize(n);
    }

    public int[] getSelectionList() {
        return this.text.getSelectionList();
    }

    public void setSelectionList(int[] nArray) {
        this.text.setSelectionList(nArray);
    }

    public Color getSelectedBackground() {
        return this.text.getSelectedBackground();
    }

    public void setSelectedBackground(Color color) {
        this.text.setSelectedBackground(color);
    }

    public Color getSelectedForeground() {
        return this.text.getSelectedForeground();
    }

    public void setSelectedForeground(Color color) {
        this.text.setSelectedForeground(color);
    }

    public int pointToPosition(int n, int n2) {
        return this.text.pointToPosition(n, n2);
    }

    public void showPosition(int n) {
        this.text.showPosition(n);
    }

    public int getCursorPosition() {
        return this.text.getCursorPosition();
    }

    public void setCursorPosition(int n) {
        this.text.setCursorPosition(n);
    }

    public void setOverstrike(boolean bl) {
        this.text.setOverstrike(bl);
    }

    public boolean getOverstrike() {
        return this.text.getOverstrike();
    }

    public int getLastPosition() {
        return this.text.getLastPosition();
    }

    public boolean getShowCursorPosition() {
        return this.text.getShowCursorPosition();
    }

    public void setShowCursorPosition(boolean bl) {
        this.text.setShowCursorPosition(bl);
    }

    public void addTextListener(JCTextListener jCTextListener) {
        this.text.addTextListener(jCTextListener);
    }

    public void removeTextListener(JCTextListener jCTextListener) {
        this.text.removeTextListener(jCTextListener);
    }

    public void addTextCursorListener(JCTextCursorListener jCTextCursorListener) {
        this.text.addTextCursorListener(jCTextCursorListener);
    }

    public void removeTextCursorListener(JCTextCursorListener jCTextCursorListener) {
        this.text.removeTextCursorListener(jCTextCursorListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        if (this.text != null) {
            this.text.addFocusListener(focusListener);
        }
    }

    public void removeFocusListener(FocusListener focusListener) {
        if (this.text != null) {
            this.text.removeFocusListener(focusListener);
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        if (this.text != null) {
            this.text.addKeyListener(keyListener);
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (this.text != null) {
            this.text.removeKeyListener(keyListener);
        }
    }

    public int getShadowThickness() {
        return this.border;
    }

    public void setShadowThickness(int n) {
        this.border = n;
    }

    public int getHighlightThickness() {
        return this.text.getHighlightThickness();
    }

    public void setHighlightThickness(int n) {
        this.text.setHighlightThickness(n);
    }

    public Color getHighlightColor() {
        return this.text.getHighlightColor();
    }

    public void setHighlightColor(Color color) {
        this.text.setHighlightColor(color);
    }

    public synchronized void setText(String string) {
    }

    public synchronized String getText() {
        return "";
    }

    class textKeyListener
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            JCSpinEvent jCSpinEvent = null;
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 38: {
                    if (!JCSpin.this.arrow_key_spinning_allowed) break;
                    jCSpinEvent = new JCSpinEvent(this, JCSpinEvent.SPIN_UP, JCSpin.this.text.getText());
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    if (!JCSpin.this.arrow_key_spinning_allowed) break;
                    jCSpinEvent = new JCSpinEvent(this, JCSpinEvent.SPIN_DOWN, JCSpin.this.text.getText());
                    keyEvent.consume();
                    break;
                }
            }
            if (jCSpinEvent != null) {
                Enumeration enumeration = JCListenerList.elements(JCSpin.this.listener_list);
                while (enumeration.hasMoreElements()) {
                    JCSpinListener jCSpinListener = (JCSpinListener)enumeration.nextElement();
                    jCSpinListener.spin(jCSpinEvent);
                }
                JCSpin.this.checkArrowButtons();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        textKeyListener() {
            JCSpin.this = JCSpin.this;
        }
    }
}

